/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.nonliving;

import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownRockEntity
extends ThrowableItemProjectile {
    public ThrownRockEntity(EntityType<? extends ThrownRockEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ThrownRockEntity(Level world, LivingEntity owner) {
        super(EntityInit.THROWN_ROCK, owner, world);
    }

    public ThrownRockEntity(Level world, double x, double y, double z) {
        super(EntityInit.THROWN_ROCK, x, y, z, world);
    }

    public Item m_7881_() {
        return Items.f_42755_;
    }

    @Environment(value=EnvType.CLIENT)
    private ParticleOptions getParticleParameters() {
        BlockState state = this.m_217002_();
        return new BlockParticleOption(ParticleTypes.f_123794_, state);
    }

    @Environment(value=EnvType.CLIENT)
    public void m_7822_(byte status) {
        if (status == 3) {
            ParticleOptions particleEffect = this.getParticleParameters();
            for (int i = 0; i < 32; ++i) {
                this.m_9236_().m_7106_(particleEffect, this.m_20185_() + this.m_9236_().m_213780_().m_188500_() * 0.35 - 0.175, this.m_20186_(), this.m_20189_() + this.m_9236_().m_213780_().m_188500_() * 0.35 - 0.175, 0.0, 0.1, 0.0);
            }
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        BlockState state = this.m_217002_();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 32; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_() + this.m_9236_().f_46441_.m_188500_() * 0.35 - 0.175, this.m_20186_(), this.m_20189_() + this.m_9236_().f_46441_.m_188500_() * 0.35 - 0.175, 0.0, 0.1, 0.0);
            }
        } else {
            if (this.m_19749_() instanceof Player && ((Player)this.m_19749_()).m_21023_(EffectInit.BLACKSTONED_HEART)) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 1.5f, false, Level.ExplosionInteraction.MOB);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundInit.ROCK_IMPACT_EVENT, SoundSource.BLOCKS, 0.7f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public ItemStack m_7846_() {
        ItemStack itemStack = this.m_37454_();
        return itemStack.m_41619_() ? new ItemStack((ItemLike)this.m_7881_()) : itemStack;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_9236_().m_5776_()) {
            Entity entity = entityHitResult.m_82443_();
            Entity owner = this.m_19749_();
            DamageSource damageSource = this.createDamageSource((Entity)this, (Entity)(owner == null ? this : owner));
            if (owner instanceof LivingEntity && entity.m_6469_(damageSource, 16.0f) && entity instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity, entity);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int slownessAddition = 400;
                if (this.m_7846_().m_41720_() == this.m_7881_()) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 2000, 2));
                    slownessAddition = 200;
                }
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 50, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessAddition, slownessAddition / 200 - 1));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 1));
            }
        }
    }

    private DamageSource createDamageSource(Entity entity, Entity owner) {
        return entity.m_269291_().m_268998_(EntityInit.ROCK_KEY, entity, owner);
    }
}

